 ; Ŀ
 ;   Term - put an arrowhead on a line.                                    
 ;   Copyright 1994, 2001, 2010 by Rocket Software Ltd.                    
 ;   Rocket - the barnacles of software.                                   
 ; 

 ; Ŀ
 ;   Emp - error handler.                                                  
 ; 
 (DEFUN EMP (shk /)
  (setq *error* esav)
  (setvar "snapmode" snapp)
  (setvar "blipmode" blip)
  (if (and (/= shk "Function cancelled")
           (/= shk ""))
      (write-line shk))
 (princ))
 ; Ŀ
 ;   Emp end.                                                              
 ; 

 ; Ŀ
 ;   Term.                                                                 
 ; 
 (DEFUN C:TERM (/ blip disc lin ept layy aa bb ang s1 s2)
  (setvar "cmdecho" 0)
  (command "undo" "mark")
  (setq esav *error*)
  (setq *error* emp)
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Get the scale, depending on which space we are in and other things.   
 ; 
  (if misps
      (setq disc (misps))
      (setq disc (getvar "dimscale")))
  (setq disc (* disc (getvar "dimasz")))
  (setq ept (entsel "Pick a line: "))
  (if ept (setq lin (entget (car ept))))
  (if (= (cdr (assoc 0 lin)) "LINE")
      (progn
           (setq ept (cadr ept))
           (setq aa (cdr (assoc 10 lin)))
           (setq bb (cdr (assoc 11 lin)))
           (if (> (distance aa ept) (distance bb ept))
               (progn (setq ept aa) (setq aa bb) (setq bb ept)))
           (setq ang (angle aa bb))
           (setq s1 (polar aa ang disc))
           (setq s2 (polar s1 (+ ang (/ pi 2)) (/ disc 6)))
           (setq s1 (polar s2 (+ ang (* pi 1.5)) (/ disc 3)))
           (command "solid" s1 s2 aa "" "")
           (setq entt (entget (entlast)))
           (cond ((and (assoc 62 entt) (assoc 62 lin))
                  (setq entt (subst (assoc 62 lin) (assoc 62 entt) entt)))
                 ((assoc 62 lin)
                  (setq entt (append entt (list (assoc 62 lin))))))
           (entmod (subst (assoc 8 lin) (assoc 8 entt) entt))))
  (emp "")
 (princ))